/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.com/copyright-license

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

uniform float wetness;

uniform vec3 sunvec;
uniform vec3 moonvec;

uniform vec4 daytime;

flat out mat4x3 lightColor;

#ifdef skypass
uniform vec3 skyColor;
uniform vec3 fogColor;

flat out mat2x3 skyColorMat;

#include "/lib/util/colorspace.glsl"

#endif

#ifdef cloudpass
flat out vec3 cloudLightColor;
#endif

void getColorPalette() {
    
    vec3 sunlightSunrise;
        sunlightSunrise.r   = 0.79;
        sunlightSunrise.g   = 0.306;
        sunlightSunrise.b   = 0.03;
        sunlightSunrise    *= 0.7;

    vec3 sunlightNoon;
        sunlightNoon.r      = 1.0;
        sunlightNoon.g      = 0.93;
        sunlightNoon.b      = 0.72;
        sunlightNoon       *= 1.0;

    vec3 sunlightSunset;
        sunlightSunset.r    = 0.79;
        sunlightSunset.g    = 0.29;
        sunlightSunset.b    = 0.04;
        sunlightSunset     *= 0.7;

    vec3 sunlightNight;
        sunlightNight.r     = 0.69;
        sunlightNight.g     = 0.27;
        sunlightNight.b     = 0.04;
        sunlightNight      *= 0.1;

    lightColor[0]  = sunlightSunrise*daytime.x + sunlightNoon*daytime.y + sunlightSunset*daytime.z + sunlightNight*daytime.w;
    lightColor[0]  *= 16.0 * sunlightIllum;
    lightColor[0]  = mix(lightColor[0], vec3(v3avg(lightColor[0])) * 0.2, wetness * 0.95);
    
    vec3 skylightSunrise;
        skylightSunrise.r   = 0.81;
        skylightSunrise.g   = 0.80;
        skylightSunrise.b   = 0.97;
        skylightSunrise    *= 0.3;

    vec3 skylightNoon;
        skylightNoon.r      = 0.75;
        skylightNoon.g      = 0.84;
        skylightNoon.b      = 0.98;
        skylightNoon       *= 0.5;

    vec3 skylightSunset;
        skylightSunset.r    = 0.81;
        skylightSunset.g    = 0.80;
        skylightSunset.b    = 0.97;
        skylightSunset     *= 0.31;

    vec3 skylightNight;
        skylightNight.r     = 0.33;
        skylightNight.g     = 0.49;
        skylightNight.b     = 0.94;
        skylightNight      *= 0.01;

    lightColor[1]  = skylightSunrise*daytime.x + skylightNoon*daytime.y + skylightSunset*daytime.z + skylightNight*daytime.w;
    lightColor[1] *= skylightIllum;
    lightColor[1]  = mix(lightColor[1], vec3(v3avg(lightColor[1])) * 2.0, wetness * 0.95);

    lightColor[2]  = vec3(0.22, 0.33, 1.0)*0.17;
    lightColor[2]  = mix(lightColor[2], vec3(v3avg(lightColor[2])) * 0.2, wetness * 0.95);

    lightColor[3]  = blackbody(blocklightBaseTemp) * blocklightIllum;

    #ifdef skypass
        vec3 skyColorIn  = linearToAP1(toLinear(skyColor)) * sqrt2;

        vec3 skySunrise = skyColorIn;
            //skySunrise.r = 0.24;
            //skySunrise.g = 0.52;
            //skySunrise.b = 1.00;
            skySunrise  *= 1.0;

        vec3 skyNoon = skyColorIn * vec3(0.97, 1.18, 1.04);
            //skyNoon.r   = 0.222;
            //skyNoon.g   = 0.486;
            //skyNoon.b   = 1.00;
            skyNoon    *= 1.15;

        vec3 skySunset = skyColorIn;
            //skySunset.r = 0.24;
            //skySunset.g = 0.52;
            //skySunset.b = 1.00;
            skySunset  *= 1.0;

        vec3 skyNight;
            skyNight.r  = 0.08;
            skyNight.g  = 0.5;
            skyNight.b  = 1.00;
            skyNight   *= 0.006;

        skyColorMat[0]    = skySunrise*daytime.x + skyNoon*daytime.y + skySunset*daytime.z + skyNight*daytime.w;
        skyColorMat[0]  = mix(skyColorMat[0], vec3(v3avg(skyColorMat[0])) * 1.1, wetness * 0.8);

        vec3 horSunrise;
            horSunrise.r = 0.65;
            horSunrise.g = 0.18;
            horSunrise.b = 0.06;
            horSunrise  *= 1.25;

        vec3 horNoon;
            horNoon.r   = 0.59;
            horNoon.g   = 0.71;
            horNoon.b   = 0.96;
            horNoon    *= 2.7;

        vec3 horSunset;
            horSunset.r = 0.65;
            horSunset.g = 0.16;
            horSunset.b = 0.06;
            horSunset  *= 1.2;

        vec3 horNight;
            horNight.r  = 0.08;
            horNight.g  = 0.5;
            horNight.b  = 1.00;
            horNight   *= 0.015;

        skyColorMat[1]    = horSunrise*sqr(daytime.x) + horNoon*(1.0 - sqr(1.0 - daytime.y)) + horSunset*sqr(daytime.z) + horNight*(1.0 - sqr(1.0 - daytime.w));
        skyColorMat[1]  = mix(skyColorMat[1], vec3(v3avg(skyColorMat[1])), wetness * 0.8);
    #endif

    #ifdef cloudpass
        vec3 c_sunlightSunrise;
            c_sunlightSunrise.r   = 0.67;
            c_sunlightSunrise.g   = 0.20;
            c_sunlightSunrise.b   = 0.05;
            c_sunlightSunrise    *= 0.45;

        vec3 c_sunlightNoon;
            c_sunlightNoon.r      = 0.95;
            c_sunlightNoon.g      = 0.90;
            c_sunlightNoon.b      = 0.76;
            c_sunlightNoon       *= 0.9;

        vec3 c_sunlightSunset;
            c_sunlightSunset.r    = 0.65;
            c_sunlightSunset.g    = 0.18;
            c_sunlightSunset.b    = 0.04;
            c_sunlightSunset     *= 0.45;

        vec3 c_sunlightNight;
            c_sunlightNight.r     = 0.65;
            c_sunlightNight.g     = 0.14;
            c_sunlightNight.b     = 0.03;
            c_sunlightNight      *= 0.25;

        vec3 cloud_sunlight  = c_sunlightSunrise*sqr(daytime.x) + c_sunlightNoon*(1.0 - sqr(1.0 - daytime.y)) + c_sunlightSunset*sqr(daytime.z) + c_sunlightNight*(1.0 - sqr(1.0 - daytime.w));
        cloud_sunlight *= 16.0;

        cloudLightColor = cloud_sunlight;
        cloudLightColor  = mix(cloudLightColor, vec3(v3avg(cloudLightColor)) * 0.2, wetness * 0.8);
    #endif
}